<?php
header('Content-Type: application/json');

$config = require 'config.php';

function getPDOConnection($config)
{
    $dsn = "mysql:host={$config['database']['host']};dbname={$config['database']['db']};charset={$config['database']['charset']}";
    $options = [
        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES   => false,
    ];

    try {
        $pdo = new PDO($dsn, $config['database']['user'], $config['database']['pass'], $options);
        return $pdo;
    } catch (\PDOException $e) {
        file_put_contents('log.txt', 'Database connection failed: ' . $e->getMessage() . "\n", FILE_APPEND);
        echo json_encode(['is_manager' => false, 'error' => 'Database connection failed']);
        exit;
    }
}

$pdo = getPDOConnection($config);

function isManager($pdo, $userId)
{
    try {
        $stmt = $pdo->prepare('SELECT id FROM managers WHERE chat_id = :chat_id LIMIT 1');
        $stmt->execute(['chat_id' => $userId]);
        return $stmt->fetch() !== false;
    } catch (\PDOException $e) {
        file_put_contents('log.txt', 'Failed to check if user_id is manager: ' . $e->getMessage() . "\n", FILE_APPEND);
        return false;
    }
}

$userId = isset($_POST['user_id']) ? $_POST['user_id'] : null;

if ($userId === null) {
    echo json_encode(['is_manager' => false, 'error' => 'No user_id provided']);
    exit;
}

$is_manager = isManager($pdo, $userId);
echo json_encode(['is_manager' => $is_manager]);
?>