<?php
// --- ПРОВЕРКА АВТОРИЗАЦИИ, ПОДКЛЮЧЕНИЕ К БД, ЛОГИКА ПАГИНАЦИИ ---
// (Вся эта PHP-логика остается такой же, как в предыдущем ответе)
session_start();

if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header('Location: admin.php');
    exit;
}

$config = require 'config.php';
$db_config = $config['database'];
$pdo = null;

try {
    $dsn = "mysql:host={$db_config['host']};dbname={$db_config['db']};charset={$db_config['charset']}";
    $options = [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION, PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC, PDO::ATTR_EMULATE_PREPARES => false];
    $pdo = new PDO($dsn, $db_config['user'], $db_config['pass'], $options);
} catch (\PDOException $e) {
    die("Ошибка подключения к базе данных: " . $e->getMessage());
}

function generate_pagination_ui($currentPage, $totalPages, $paramName, $otherParams = []) {
    if ($totalPages <= 1) return;
    $queryString = http_build_query($otherParams);
    $window = 1;
    echo '<nav class="flex items-center justify-center space-x-1 mt-4">';
    if ($currentPage > 1) {
        echo '<a href="?' . $paramName . '=' . ($currentPage - 1) . '&' . $queryString . '" class="px-3 py-1 text-sm rounded-md bg-white text-gray-700 hover:bg-gray-200 shadow-sm">«</a>';
    } else {
        echo '<span class="px-3 py-1 text-sm rounded-md bg-gray-100 text-gray-400 cursor-not-allowed shadow-sm">«</span>';
    }
    for ($i = 1; $i <= $totalPages; $i++) {
        if ($i == 1 || $i == $totalPages || ($i >= $currentPage - $window && $i <= $currentPage + $window)) {
            $activeClass = ($i == $currentPage) ? 'bg-sky-600 text-white' : 'bg-white text-gray-700 hover:bg-gray-200';
            echo '<a href="?' . $paramName . '=' . $i . '&' . $queryString . '" class="px-3 py-1 text-sm rounded-md shadow-sm ' . $activeClass . '">' . $i . '</a>';
        } elseif ($i == $currentPage - $window - 1 || $i == $currentPage + $window + 1) {
            echo '<span class="px-3 py-1 text-sm text-gray-500">...</span>';
        }
    }
    if ($currentPage < $totalPages) {
        echo '<a href="?' . $paramName . '=' . ($currentPage + 1) . '&' . $queryString . '" class="px-3 py-1 text-sm rounded-md bg-white text-gray-700 hover:bg-gray-200 shadow-sm">»</a>';
    } else {
        echo '<span class="px-3 py-1 text-sm rounded-md bg-gray-100 text-gray-400 cursor-not-allowed shadow-sm">»</span>';
    }
    echo '</nav>';
}

$records_per_page = 15;
$page_errors = isset($_GET['p_errors']) ? (int)$_GET['p_errors'] : 1;
$offset_errors = ($page_errors - 1) * $records_per_page;
$total_errors = $pdo->query('SELECT COUNT(*) FROM errors')->fetchColumn();
$total_pages_errors = $total_errors > 0 ? ceil($total_errors / $records_per_page) : 1;
$errors_stmt = $pdo->prepare("SELECT e.*, c.name as client_name FROM errors e LEFT JOIN clients c ON e.client_id = c.id ORDER BY e.created_at DESC LIMIT :limit OFFSET :offset");
$errors_stmt->bindValue(':limit', $records_per_page, PDO::PARAM_INT);
$errors_stmt->bindValue(':offset', $offset_errors, PDO::PARAM_INT);
$errors_stmt->execute();
$errors = $errors_stmt->fetchAll();

$page_clients = isset($_GET['p_clients']) ? (int)$_GET['p_clients'] : 1;
$offset_clients = ($page_clients - 1) * $records_per_page;
$total_clients = $pdo->query('SELECT COUNT(*) FROM clients')->fetchColumn();
$total_pages_clients = $total_clients > 0 ? ceil($total_clients / $records_per_page) : 1;
$clients_stmt = $pdo->prepare("SELECT * FROM clients ORDER BY id DESC LIMIT :limit OFFSET :offset");
$clients_stmt->bindValue(':limit', $records_per_page, PDO::PARAM_INT);
$clients_stmt->bindValue(':offset', $offset_clients, PDO::PARAM_INT);
$clients_stmt->execute();
$clients = $clients_stmt->fetchAll();

$stats = ['errors' => $total_errors, 'clients' => $total_clients, 'managers' => $pdo->query('SELECT COUNT(*) FROM managers')->fetchColumn(), 'suppliers' => $pdo->query('SELECT COUNT(*) FROM suppliers')->fetchColumn()];
?>
<!DOCTYPE html>
<html lang="ru" class="h-full bg-gray-100">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>База данных - Админ-панель</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
</head>
<body class="h-full">

    <div>
        <?php require 'admin_sidebar.php'; // <-- ПОДКЛЮЧАЕМ САЙДБАР ОДНОЙ СТРОКОЙ ?>

        <div class="flex flex-col flex-1 md:pl-64">
            <div class="sticky top-0 z-10 md:hidden h-16 bg-white shadow-sm flex items-center px-4">
                <button id="hamburger-btn" type="button" class="text-gray-500 hover:text-gray-600">
                    <i class="fas fa-bars text-xl"></i>
                </button>
                <div class="flex-1 text-center text-lg font-medium">База данных</div>
            </div>

            <main class="flex-1 p-6">
                <div class="max-w-7xl mx-auto">
                    <h1 class="text-3xl font-bold text-gray-900">База данных</h1>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 my-6">
                         <div class="bg-white p-6 rounded-lg shadow-md">
                            <i class="fas fa-bug text-3xl text-red-500"></i>
                            <p class="text-3xl font-semibold mt-2"><?php echo $stats['errors']; ?></p>
                            <p class="text-gray-500">Всего ошибок</p>
                        </div>
                        <div class="bg-white p-6 rounded-lg shadow-md">
                            <i class="fas fa-users text-3xl text-sky-500"></i>
                            <p class="text-3xl font-semibold mt-2"><?php echo $stats['clients']; ?></p>
                            <p class="text-gray-500">Клиентов</p>
                        </div>
                        <div class="bg-white p-6 rounded-lg shadow-md">
                            <i class="fas fa-user-tie text-3xl text-green-500"></i>
                            <p class="text-3xl font-semibold mt-2"><?php echo $stats['managers']; ?></p>
                            <p class="text-gray-500">Менеджеров</p>
                        </div>
                        <div class="bg-white p-6 rounded-lg shadow-md">
                            <i class="fas fa-truck text-3xl text-purple-500"></i>
                            <p class="text-3xl font-semibold mt-2"><?php echo $stats['suppliers']; ?></p>
                            <p class="text-gray-500">Поставщиков</p>
                        </div>
                    </div>

                    <div class="bg-white rounded-lg shadow-md overflow-hidden mt-8">
                        <h2 class="text-xl font-bold text-gray-800 p-4 border-b">Ошибки</h2>
                        <div class="overflow-x-auto">
                            <table class="w-full text-sm text-left text-gray-500">
                                <thead class="text-xs text-gray-700 uppercase bg-gray-50">
                                    <tr><th scope="col" class="px-6 py-3">ID</th><th scope="col" class="px-6 py-3">Клиент</th><th scope="col" class="px-6 py-3">Описание</th><th scope="col" class="px-6 py-3">Статус</th><th scope="col" class="px-6 py-3">Дата</th></tr>
                                </thead>
                                <tbody>
                                    <?php if (empty($errors)): ?>
                                        <tr><td colspan="5" class="text-center p-4">Записи не найдены.</td></tr>
                                    <?php else: foreach ($errors as $error): ?>
                                        <tr class="bg-white border-b hover:bg-gray-50"><td class="px-6 py-4 font-medium text-gray-900"><?php echo htmlspecialchars($error['id']); ?></td><td class="px-6 py-4"><?php echo htmlspecialchars($error['client_name'] ?? 'N/A'); ?></td><td class="px-6 py-4 break-words"><?php echo htmlspecialchars($error['description']); ?></td><td class="px-6 py-4"><span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-blue-100 text-blue-800"><?php echo htmlspecialchars($error['status']); ?></span></td><td class="px-6 py-4"><?php echo date('Y-m-d H:i', strtotime($error['created_at'])); ?></td></tr>
                                    <?php endforeach; endif; ?>
                                </tbody>
                            </table>
                        </div>
                        <?php generate_pagination_ui($page_errors, $total_pages_errors, 'p_errors', ['p_clients' => $page_clients]); ?>
                    </div>
                    
                    <div class="bg-white rounded-lg shadow-md overflow-hidden mt-8">
                        <h2 class="text-xl font-bold text-gray-800 p-4 border-b">Клиенты</h2>
                        <div class="overflow-x-auto">
                           <table class="w-full text-sm text-left text-gray-500">
                             <thead class="text-xs text-gray-700 uppercase bg-gray-50"><tr><th scope="col" class="px-6 py-3">ID</th><th scope="col" class="px-6 py-3">Имя</th><th scope="col" class="px-6 py-3">Chat ID</th></tr></thead>
                            <tbody>
                                 <?php if (empty($clients)): ?>
                                     <tr><td colspan="3" class="text-center p-4">Записи не найдены.</td></tr>
                                 <?php else: foreach ($clients as $client): ?>
                                    <tr class="bg-white border-b hover:bg-gray-50"><td class="px-6 py-4 font-medium text-gray-900"><?php echo htmlspecialchars($client['id']); ?></td><td class="px-6 py-4"><?php echo htmlspecialchars($client['name']); ?></td><td class="px-6 py-4"><?php echo htmlspecialchars($client['chat_id']); ?></td></tr>
                                 <?php endforeach; endif; ?>
                            </tbody>
                           </table>
                        </div>
                        <?php generate_pagination_ui($page_clients, $total_pages_clients, 'p_clients', ['p_errors' => $page_errors]); ?>
                    </div>
                </div>
            </main>
        </div>
    </div>
    
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const hamburgerBtn = document.getElementById('hamburger-btn');
            const mobileSidebar = document.getElementById('mobile-sidebar');
            const backdrop = document.getElementById('mobile-sidebar-backdrop');
            if (hamburgerBtn) {
                function toggleSidebar() {
                    mobileSidebar.classList.toggle('-translate-x-full');
                    backdrop.classList.toggle('hidden');
                }
                hamburgerBtn.addEventListener('click', toggleSidebar);
                backdrop.addEventListener('click', toggleSidebar);
            }
        });
    </script>
</body>
</html>