<?php
// --- ПРОВЕРКА АВТОРИЗАЦИИ ---
session_start();

if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header('Location: admin.php');
    exit;
}

$config_file_path = 'config.php';
$success_message = '';

// --- ЛОГИКА СОХРАНЕНИЯ НАСТРОЕК ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Получаем и очищаем новые ID
    $new_admin_ids_str = $_POST['admin_ids'] ?? '';
    // Удаляем все символы, кроме цифр и запятых
    $sanitized_ids = preg_replace('/[^0-9,]/', '', $new_admin_ids_str);

    // Читаем текущий файл конфигурации
    $config_content = file_get_contents($config_file_path);

    // Формируем новую строку для массива admin_ids
    $new_line = "'admin_ids' => [{$sanitized_ids}]";

    // Заменяем старую строку на новую с помощью регулярного выражения
    // Это безопаснее, чем пересобирать весь файл
    $new_config_content = preg_replace(
        "/'admin_ids'\s*=>\s*\[.*?\]/",
        $new_line,
        $config_content
    );

    // Записываем обновленное содержимое обратно в файл
    if (file_put_contents($config_file_path, $new_config_content)) {
        $success_message = 'Настройки успешно сохранены!';
    } else {
        $success_message = 'Ошибка! Не удалось сохранить настройки. Проверьте права на запись файла config.php.';
    }
}


// --- ЧТЕНИЕ ТЕКУЩИХ НАСТРОЕК ДЛЯ ОТОБРАЖЕНИЯ ---
// require сбрасывает кэш и подгружает обновленные данные
$config = require $config_file_path;
$admin_ids_string = implode(', ', $config['admin_ids']);

?>
<!DOCTYPE html>
<html lang="ru" class="h-full bg-gray-100">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Настройки - Админ-панель</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
</head>
<body class="h-full">

    <div>
        <?php require 'admin_sidebar.php'; // Подключаем сайдбар ?>

        <div class="flex flex-col flex-1 md:pl-64">
            <div class="sticky top-0 z-10 md:hidden h-16 bg-white shadow-sm flex items-center px-4">
                <button id="hamburger-btn" type="button" class="text-gray-500 hover:text-gray-600">
                    <i class="fas fa-bars text-xl"></i>
                </button>
                <div class="flex-1 text-center text-lg font-medium">Настройки</div>
            </div>

            <main class="flex-1 p-6">
                <div class="max-w-7xl mx-auto">
                    <h1 class="text-3xl font-bold text-gray-900">Настройки</h1>

                    <div class="mt-8 max-w-2xl">
                        <div class="bg-white p-6 rounded-lg shadow-md">
                            <form method="POST" action="admin_settings.php">
                                
                                <?php if ($success_message): ?>
                                <div class="mb-4 p-4 text-sm rounded-md <?php echo strpos($success_message, 'Ошибка') !== false ? 'bg-red-100 text-red-700' : 'bg-green-100 text-green-700'; ?>">
                                    <?php echo $success_message; ?>
                                </div>
                                <?php endif; ?>

                                <div class="mb-4">
                                    <label for="admin_ids" class="block text-sm font-medium text-gray-700">
                                        ID Администраторов (через запятую)
                                    </label>
                                    <input type="text" id="admin_ids" name="admin_ids" 
                                           value="<?php echo htmlspecialchars($admin_ids_string); ?>"
                                           class="mt-1 block w-full px-3 py-2 bg-white border border-gray-300 rounded-md shadow-sm placeholder-gray-400 focus:outline-none focus:ring-sky-500 focus:border-sky-500 sm:text-sm">
                                    <p class="mt-2 text-xs text-gray-500">
                                        Укажите числовые ID пользователей Telegram, которые будут иметь доступ к админке бота.
                                    </p>
                                </div>

                                <div>
                                    <button type="submit" class="inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-sky-600 hover:bg-sky-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-sky-500">
                                        Сохранить изменения
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>
    
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            // Скрипт для мобильного меню
            const hamburgerBtn = document.getElementById('hamburger-btn');
            const mobileSidebar = document.getElementById('mobile-sidebar');
            const backdrop = document.getElementById('mobile-sidebar-backdrop');
            if (hamburgerBtn) {
                function toggleSidebar() {
                    mobileSidebar.classList.toggle('-translate-x-full');
                    backdrop.classList.toggle('hidden');
                }
                hamburgerBtn.addEventListener('click', toggleSidebar);
                backdrop.addEventListener('click', toggleSidebar);
            }
        });
    </script>
</body>
</html>