<?php

// Настройка обработки ошибок PHP
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/log_php.txt');
error_reporting(E_ALL);

// Подключение конфигурационного файла
$config = require 'config.php';


function answerCallbackQuery($callbackQueryID, $text)
{
    global $config;
    $token = $config['telegram']['token'];
    $params = [
        'callback_query_id' => $callbackQueryID,
        'text' => $text
    ];

    $ch = curl_init('https://api.telegram.org/bot' . $token . '/answerCallbackQuery');
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);

    // Отладочный вывод
    //  //file_put_contents('debug.log', $response . "\n", FILE_APPEND);
}

function editMessageReplyMarkup($chatId, $messageId, $newText, $replyMarkup)
{
    global $config;
    $token = $config['telegram']['token'];
    $url = "https://api.telegram.org/bot$token/editMessageText";

    $postFields = [
        'chat_id' => $chatId,
        'message_id' => $messageId,
        'text' => $newText,
        'parse_mode' => "html",
        'reply_markup' => json_encode($replyMarkup)
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_HTTPHEADER, array("Content-Type:application/json"));
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postFields));
    $output = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // Получаем HTTP код
    $curlError = curl_error($ch); // Получаем ошибку curl
    curl_close($ch);

    // Логируем HTTP код и ошибки cURL
    //file_put_contents('log.txt', "Edited message $messageId for chat $chatId with HTTP code $httpCode. cURL Error: $curlError\n", FILE_APPEND);

    // Также логируем ответ API
    //file_put_contents('log.txt', "API response WHILE EDITING: $output\n", FILE_APPEND);
}

// Функция для отправки сообщений через Telegram API
function sendMessage($chat_id, $text, $replyMarkup = null, $replyToMessageId = null)
{
    global $config;
    $token = $config['telegram']['token'];
    $url = "https://api.telegram.org/bot$token/sendMessage?chat_id=$chat_id&text=" . urlencode($text);

    if ($replyMarkup) {
        $url .= "&reply_markup=" . urlencode(json_encode($replyMarkup));
    }

    if ($replyToMessageId) {
        $url .= "&reply_to_message_id=$replyToMessageId";
    }

    //file_put_contents('log.txt', "Sending message to chat_id $chat_id: $text\n", FILE_APPEND);

    $response = file_get_contents($url);
    if ($response === false) {
        //file_put_contents('log.txt', "Failed to send message to chat_id $chat_id\n", FILE_APPEND);
    } else {
        //file_put_contents('log.txt', "Message sent successfully to chat_id $chat_id\n", FILE_APPEND);
    }
}

// Подключение к базе данных
function getPDOConnection($config)
{
    $dsn = "mysql:host={$config['database']['host']};dbname={$config['database']['db']};charset={$config['database']['charset']}";
    $options = [
        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES   => false,
    ];

    try {
        $pdo = new PDO($dsn, $config['database']['user'], $config['database']['pass'], $options);
        //file_put_contents('log.txt', "Database connection established.\n", FILE_APPEND);
        return $pdo;
    } catch (\PDOException $e) {
        //file_put_contents('log.txt', 'Database connection failed: ' . $e->getMessage() . "\n", FILE_APPEND);
        error_log('Ошибка подключения к базе данных: ' . $e->getMessage());
        die('Ошибка подключения к базе данных.');
    }
}

$pdo = getPDOConnection($config);

// Функции для работы с базой данных
function addManager($pdo, $chat_id, $name)
{
    try {
        $stmt = $pdo->prepare('INSERT INTO managers (chat_id, name) VALUES (:chat_id, :name)');
        $stmt->execute(['chat_id' => $chat_id, 'name' => $name]);
        //file_put_contents('log.txt', "Manager with chat_id $chat_id and name $name added.\n", FILE_APPEND);
    } catch (\PDOException $e) {
        //file_put_contents('log.txt', 'Failed to add manager: ' . $e->getMessage() . "\n", FILE_APPEND);
        error_log('Ошибка добавления менеджера: ' . $e->getMessage());
    }
}

function addSupplier($pdo, $chat_id, $name)
{
    try {
        $stmt = $pdo->prepare('INSERT INTO suppliers (chat_id, name) VALUES (:chat_id, :name)');
        $stmt->execute(['chat_id' => $chat_id, 'name' => $name]);
        //file_put_contents('log.txt', "Supplier with chat_id $chat_id and name $name added.\n", FILE_APPEND);
    } catch (\PDOException $e) {
        //file_put_contents('log.txt', 'Failed to add supplier: ' . $e->getMessage() . "\n", FILE_APPEND);
        error_log('Ошибка добавления поставщика: ' . $e->getMessage());
    }
}

function delManager($pdo, $id)
{
    try {
        $stmt = $pdo->prepare('DELETE FROM managers WHERE id = :id');
        $stmt->execute(['id' => $id]);
        //file_put_contents('log.txt', "Manager with id $id deleted.\n", FILE_APPEND);
    } catch (\PDOException $e) {
        //file_put_contents('log.txt', 'Failed to delete manager: ' . $e->getMessage() . "\n", FILE_APPEND);
        error_log('Ошибка удаления менеджера: ' . $e->getMessage());
    }
}

function delSupplier($pdo, $id)
{
    try {
        $stmt = $pdo->prepare('DELETE FROM suppliers WHERE id = :id');
        $stmt->execute(['id' => $id]);
        //file_put_contents('log.txt', "Supplier with id $id deleted.\n", FILE_APPEND);
    } catch (\PDOException $e) {
        //file_put_contents('log.txt', 'Failed to delete supplier: ' . $e->getMessage() . "\n", FILE_APPEND);
        error_log('Ошибка удаления поставщика: ' . $е->getMessage());
    }
}

function getAllManagers($pdo)
{
    try {
        $stmt = $pdo->query('SELECT id, name FROM managers');
        return $stmt->fetchAll();
    } catch (\PDOException $e) {
        //file_put_contents('log.txt', 'Failed to get managers: ' . $e->getMessage() . "\n", FILE_APPEND);
        error_log('Ошибка получения менеджеров: ' . $e->getMessage());
        return [];
    }
}

function getAllSuppliers($pdo)
{
    try {
        $stmt = $pdo->query('SELECT id, name FROM suppliers');
        return $stmt->fetchAll();
    } catch (\PDOException $e) {
        //file_put_contents('log.txt', 'Failed to get suppliers: ' . $e->getMessage() . "\n", FILE_APPEND);
        error_log('Ошибка получения поставщиков: ' . $e->getMessage());
        return [];
    }
}

// Функции для работы с состояниями администратора
function setAdminState($pdo, $chat_id, $role, $state, $extra_data = null)
{
    try {
        $stmt = $pdo->prepare('REPLACE INTO admin_states (chat_id, role, state, extra_data) VALUES (:chat_id, :role, :state, :extra_data)');
        $stmt->execute([
            'chat_id' => $chat_id,
            'role' => $role,
            'state' => $state,
            'extra_data' => $extra_data
        ]);

        //file_put_contents('log.txt', "Set state for chat_id $chat_id, role $role to $state with extra_data $extra_data.\n", FILE_APPEND);
    } catch (\PDOException $e) {
        //file_put_contents('log.txt', 'Failed to set state: ' . $е->getMessage() . "\n", FILE_APPEND);
        error_log('Ошибка установки состояния: ' . $e->getMessage());
    }
}

function getAdminState($pdo, $chat_id, $role)
{
    try {
        $stmt = $pdo->prepare('SELECT state, extra_data FROM admin_states WHERE chat_id = :chat_id AND role = :role');
        $stmt->execute(['chat_id' => $chat_id, 'role' => $role]);
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        //file_put_contents('log.txt', "Got state for chat_id $chat_id, role $role: " . json_encode($result) . "\n", FILE_APPEND);
        return $result;
    } catch (\PDOException $e) {
        //file_put_contents('log.txt', 'Failed to get state: ' . $e->getMessage() . "\n", FILE_APPEND);
        error_log('Ошибка получения состояния: ' . $e->getMessage());
        return null;
    }
}

function clearAdminState($pdo, $chat_id, $role)
{
    try {
        $stmt = $pdo->prepare('DELETE FROM admin_states WHERE chat_id = :chat_id AND role = :role');
        $stmt->execute([
            'chat_id' => $chat_id,
            'role' => $role
        ]);
        //file_put_contents('log.txt', "Cleared state for chat_id $chat_id, role $role.\n", FILE_APPEND);
    } catch (\PDOException $e) {
        //file_put_contents('log.txt', 'Failed to clear state: ' . $e->getMessage() . "\n", FILE_APPEND);
        error_log('Ошибка очистки состояния: ' . $e->getMessage());
    }
}

// Инициализация
$content = file_get_contents("php://input");
$update = json_decode($content, true);

// Логирование входящего запроса
//file_put_contents('log.txt', print_r($update, true), FILE_APPEND);

$adminIds = $config['admin_ids'];

if (isset($update['message'])) {
    $message = $update['message'];
    $chatId = $message['chat']['id'];
    $text = $message['text'];

    // Получаем текущее состояние администратора
    $stateData = getAdminState($pdo, $chatId, 'admin');
    $state = $stateData['state'];
    $extraData = $stateData['extra_data'];

    if ($text === '/start' && in_array($chatId, $adminIds)) {
        // Отправляем меню администратору
        $keyboard = [
            ['Добавить менеджера', 'Добавить поставщика'],
            ['Менеджеры', 'Поставщики']
        ];

        $replyMarkup = [
            'keyboard' => $keyboard,
            'resize_keyboard' => true,
            'one_time_keyboard' => false
        ];

        sendMessage($chatId, "Выберите действие:", $replyMarkup);
    } elseif (in_array($text, ['Добавить менеджера', 'Добавить поставщика']) && in_array($chatId, $adminIds)) {
        switch ($text) {
            case 'Добавить менеджера':
                sendMessage($chatId, "Введите chat_id менеджера:");
                setAdminState($pdo, $chatId, 'admin', 'add_manager_chat_id');
                break;
            case 'Добавить поставщика':
                sendMessage($chatId, "Введите chat_id поставщика:");
                setAdminState($pdo, $chatId, 'admin', 'add_supplier_chat_id');
                break;
        }
    } elseif ($state === 'add_manager_chat_id' || $state === 'add_supplier_chat_id') {
        if (is_numeric($text)) {
            // Сохраняем временно введенный chat_id в extra_data
            setAdminState($pdo, $chatId, 'admin', $state . '_name', $text);
            sendMessage($chatId, "Теперь введите имя:");
        } else {
            sendMessage($chatId, "Ошибка: ожидается числовой chat_id.");
        }
    } elseif ($state === 'add_manager_chat_id_name' || $state === 'add_supplier_chat_id_name') {
        if ($state === 'add_manager_chat_id_name') {
            addManager($pdo, $extraData, $text);
            sendMessage($chatId, "Менеджер добавлен.");
        } elseif ($state === 'add_supplier_chat_id_name') {
            addSupplier($pdo, $extraData, $text);
            sendMessage($chatId, "Поставщик добавлен.");
        }

        // Очищаем состояние
        clearAdminState($pdo, $chatId, 'admin');
    } elseif ($text === 'Менеджеры' && in_array($chatId, $adminIds)) {
        $managers = getAllManagers($pdo);
        $keyboard = [];

        foreach ($managers as $manager) {
            $keyboard[] = [
                [
                    'text' => $manager['name'] . " | Удалить ❌",
                    'callback_data' => 'delete_manager_' . $manager['id']
                ]
            ];
        }

        $replyMarkup = [
            'inline_keyboard' => $keyboard
        ];

        sendMessage($chatId, "Список менеджеров:", $replyMarkup);
    } elseif ($text === 'Поставщики' && in_array($chatId, $adminIds)) {
        $suppliers = getAllSuppliers($pdo);
        $keyboard = [];

        foreach ($suppliers as $supplier) {
            $keyboard[] = [
                [
                    'text' => $supplier['name'] . " | Удалить ❌",
                    'callback_data' => 'delete_supplier_' . $supplier['id']
                ]
            ];
        }

        $replyMarkup = [
            'inline_keyboard' => $keyboard
        ];

        sendMessage($chatId, "Список поставщиков:", $replyMarkup);
    }
} elseif (isset($update['callback_query'])) {
    $callbackQuery = $update['callback_query'];
    $chatId = $callbackQuery['message']['chat']['id'];
    $data = $callbackQuery['data'];

    if (strpos($data, 'delete_manager_') === 0) {
        $managerId = str_replace('delete_manager_', '', $data);
        delManager($pdo, $managerId);
        sendMessage($chatId, "Менеджер удален.");
    } elseif (strpos($data, 'delete_supplier_') === 0) {
        $supplierId = str_replace('delete_supplier_', '', $data);
        delSupplier($pdo, $supplierId);
        sendMessage($chatId, "Поставщик удален.");
    }
}

// Подключаем файл clients.php
require 'clients.php';

// Логика обработки входящего сообщения
if (isset($update['message'])) {
    $message = $update['message'];
    $chatId = $message['chat']['id'];
    $text = $message['text'];

    // Проверяем, является ли чат менеджером или поставщиком
    if (!isManager($pdo, $chatId) && !isSupplier($pdo, $chatId)) {
        // Если это не менеджер и не поставщик, обрабатываем сообщение как от клиента
        handleClientMessage($pdo, $chatId, $message);
    }

    // Здесь продолжается остальная логика для администраторов и т.д.
}

if (isset($update['callback_query'])) {
    $callbackQuery = $update['callback_query'];
    $chatId = $callbackQuery['message']['chat']['id'];
    $messageId = $callbackQuery['message']['message_id'];
    $data = $callbackQuery['data'];
    $userId = $callbackQuery['from']['id'];
    $callbackQueryID = $callbackQuery['id'];
    // Логирование всех данных из callback_query
    //file_put_contents('log.txt', "Received callback_query: " . print_r($callbackQuery, true) . "\n", FILE_APPEND);





    // Обработка нажатия на кнопку "Не найдено"
    if (strpos($data, 'not_found_error_') === 0) {
        $errorId = str_replace('not_found_error_', '', $data);

        // Получаем информацию об ошибке
        $stmt = $pdo->prepare('SELECT client_id, client_message_id, description FROM errors WHERE id = :id');
        $stmt->execute(['id' => $errorId]);
        $errorData = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($errorData) {
            $clientId = $errorData['client_id'];
            $clientMessageId = $errorData['client_message_id'];

            // Получаем chat_id клиента
            $stmt = $pdo->prepare('SELECT chat_id FROM clients WHERE id = :client_id');
            $stmt->execute(['client_id' => $clientId]);
            $clientChatId = $stmt->fetchColumn();

            if ($clientChatId) {
                $pattern = '/^(7\d{10}|375\d{9})\s+(.+)$/';
                if (preg_match($pattern, $errorData['description'], $matches)) {
                    $phoneNumber = $matches[1];
                    $errorText = $matches[2];
                } else {
                    $phoneNumber = 'Не найден';
                    $errorText = $errorMessage;
                }
                // Отправляем сообщение клиенту с реакцией ❌
                answerCallbackQuery($callbackQueryID, "Ошибка 'Не найдено' отправлена клиенту❌");

                sendMessage($clientChatId, $errorData['description'] . " - Данный вызов не найден в нашей базе. Просьба проверить верность " . $phoneNumber . " номера.", null, $clientMessageId);
                sendReaction($clientChatId, $clientMessageId, '🤷‍♂️');
            } else {
                sendMessage($chatId, "Произошла ошибка: не удалось найти chat_id клиента.");
            }
        } else {
            sendMessage($chatId, "Произошла ошибка: не удалось найти данные для указанной ошибки.");
        }
    }

    // Обработка нажатия на кнопку "Исправлено"
    if (strpos($data, 'fix_error_') === 0) {
        $errorId = str_replace('fix_error_', '', $data);

        // Логирование полученного errorId
        //file_put_contents('log.txt', "Processing fix for errorId: $errorId\n", FILE_APPEND);

        // Обновление статуса ошибки
        $stmt = $pdo->prepare('UPDATE errors SET status = :status WHERE id = :id');
        $stmt->execute(['status' => 'fixed', 'id' => $errorId]);

        // Логирование результата обновления статуса
        if ($stmt->rowCount() > 0) {
            //file_put_contents('log.txt', "Status for errorId $errorId updated to 'fixed'.\n", FILE_APPEND);
        } else {
            //file_put_contents('log.txt', "Failed to update status for errorId $errorId. No rows affected.\n", FILE_APPEND);
        }

        // Получение информации об ошибке
        $stmt = $pdo->prepare('SELECT client_id, client_message_id, description,supplier_msg,manager_id FROM errors WHERE id = :id');
        $stmt->execute(['id' => $errorId]);
        $errorData = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($errorData) {
            // Логирование данных об ошибке
            //file_put_contents('log.txt', "Fetched error data: " . print_r($errorData, true) . "\n", FILE_APPEND);

            $clientId = $errorData['client_id'];
            $clientMessageId = $errorData['client_message_id'];

            // Получение chat_id клиента
            $stmt = $pdo->prepare('SELECT chat_id FROM clients WHERE id = :client_id');
            $stmt->execute(['client_id' => $clientId]);
            $clientChatId = $stmt->fetchColumn();

            // Логирование результата запроса chat_id
            //file_put_contents('log.txt', "Query result chat_id: $clientChatId for client_id: $clientId\n", FILE_APPEND);

            if ($clientChatId) {
                sendMessage($clientChatId, $errorData['description'] . "\n" . "Ошибка исправлена ✅", null, $clientMessageId);
                sendReaction($clientChatId, $clientMessageId, '👍');

                answerCallbackQuery($callbackQueryID, "Ошибка клиента исправлена ✅");

                sendReaction($errorData['manager_id'], $errorData['supplier_msg'], '👍');


                // Логирование успешной отправки сообщений и реакции
                //file_put_contents('log.txt', "Sent correction confirmation to clientChatId $clientChatId and managerChatId $chatId\n", FILE_APPEND);
            } else {
                //file_put_contents('log.txt', "Ошибка: не удалось найти chat_id для client_id $clientId\n", FILE_APPEND);
                sendMessage($chatId, "Произошла ошибка: не удалось найти chat_id клиента.");
            }
        } else {
            //file_put_contents('log.txt', "Ошибка: не удалось найти данные для ошибки с id $errorId\n", FILE_APPEND);
            sendMessage($chatId, "Произошла ошибка: не удалось найти данные для указанной ошибки.");
        }
    }


    // Обработка нажатия на кнопку "Обрабатываю"
    elseif (strpos($data, 'process_error_') === 0) {
        //file_put_contents('log.txt', "Received callback for process_error. Data: $data\n", FILE_APPEND);

        $errorId = str_replace('process_error_', '', $data);
        //file_put_contents('log.txt', "Processing error with ID: $errorId\n", FILE_APPEND);

        // Получаем данные ошибки
        $stmt = $pdo->prepare('SELECT manager_id FROM errors WHERE id = :id');
        $stmt->execute(['id' => $errorId]);
        $errorData = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($errorData) {
            //file_put_contents('log.txt', "Fetched error data: " . print_r($errorData, true) . "\n", FILE_APPEND);
        } else {
            //file_put_contents('log.txt', "Error data not found for errorId: $errorId\n", FILE_APPEND);
            sendMessage($chatId, "Ошибка: не удалось найти данные для ошибки.");
            return;
        }

        $msgm = $callbackQuery['message']['message_id'];
        $chatIdd = $callbackQuery['message']['chat']['id'];

        // Обновляем данные об ошибке
        $stmt = $pdo->prepare('UPDATE errors SET manager_id = :manager_id, status = :status ,supplier_msg = :supplier_msg  WHERE id = :id');
        $stmt->execute(['manager_id' => $chatIdd, 'supplier_msg' => $msgm, 'status' => 'processing', 'id' => $errorId]);

        //file_put_contents('log.txt', "Updated error with ID: $errorId. Manager ID: $chatIdd\n", FILE_APPEND);

        $suppliers = getAllSuppliers($pdo);
        $keyboard = [];
        foreach ($suppliers as $supplier) {
            $keyboard[] = [
                [
                    'text' => $supplier['name'],
                    'callback_data' => "send_error_to_supplier_{$supplier['id']}_$errorId"
                ]
            ];
        }

        $replyMarkup = [
            'inline_keyboard' => $keyboard
        ];

        // Вместо отправки нового сообщения, редактируем текущее сообщение
        //file_put_contents('log.txt', "Attempting to edit message $msgm for chat $chatId\n", FILE_APPEND);
        editMessageReplyMarkup($chatId, $msgm, "Выберите поставщика для отправки ошибки:", $replyMarkup);
    } elseif (strpos($data, 'send_error_to_supplier_') === 0) {
        if (preg_match('/send_error_to_supplier_(\d+)_(\d+)/', $data, $matches)) {
            $supplierId = $matches[1];
            $errorId = $matches[2];

            // Получаем имя поставщика
            $stmt = $pdo->prepare('SELECT name FROM suppliers WHERE id = :id');
            $stmt->execute(['id' => $supplierId]);
            $supplierName = $stmt->fetchColumn();

            // Обработка отправки ошибки поставщику (например, через API)
            if ($supplierName === 'Amerik') {
                // Специальная обработка для Amerik
                $supplierChatId = $chatId;

                // Подготовка данных для отправки через API
                $apiUrl = 'https://SMSAPI.Hefservice.com/api';
                $postData = [
                    'chat_id' => $supplierChatId,
                    'text' => $errorData['description'] // сообщение с ошибкой
                ];
                function sendSms($chat_id, $text)
                {
                    // Проверка chat_id на числовое значение
                    if (!is_numeric($chat_id)) {
                        throw new InvalidArgumentException('chat_id должен быть числом.');
                    }
                    // URL для отправки запроса
                    $url = 'https://smsapi.hefservice.com/api/';
                    // Данные для отправки
                    $data = [
                        'chat_id' => $chat_id,
                        'text' => $text
                    ];
                    // Инициализация cURL
                    $ch = curl_init($url);
                    // Настройки cURL
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($ch, CURLOPT_POST, true);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
                    // Выполнение запроса
                    $response = curl_exec($ch);
                    // Проверка на ошибки
                    if (curl_errno($ch)) {
                        echo 'Ошибка cURL: ' . curl_error($ch);
                    } else {
                        // Обработка ответа

                    }
                    // Закрытие cURL сессии
                    curl_close($ch);
                    return $response;
                } // Восстанавливаем исходное сообщение для менеджера с кнопками "Обрабатываю" и "Исправлено"
                $stmt = $pdo->prepare('SELECT description FROM errors WHERE id = :id');
                $stmt->execute(['id' => $errorId]);
                $errorDescription = $stmt->fetchColumn();

                // Выполняем отправку сообщения поставщику (пример функции sendSms)
                $response = sendSms(-1001915459484, $errorDescription);
            }

            // Восстанавливаем исходное сообщение для менеджера с кнопками "Обрабатываю" и "Исправлено"
            $stmt = $pdo->prepare('SELECT description FROM errors WHERE id = :id');
            $stmt->execute(['id' => $errorId]);
            $errorDescription = $stmt->fetchColumn();

            $replyMarkup = [
                'inline_keyboard' => [
                    [
                        [
                            'text' => 'Обрабатываю',
                            'callback_data' => "process_error_$errorId"
                        ],
                        [
                            'text' => 'Исправлено',
                            'callback_data' => "fix_error_$errorId"
                        ]
                    ]
                ]
            ];

            $pattern = '/^(\S+)\s+(.+)$/';
            if (preg_match($pattern, $errorDescription, $matches)) {
                $firstPart = $matches[1]; // Часть до первого пробела
                $secondPart = $matches[2]; // Часть после пробела
            } else {
                // Если формат не соответствует ожидаемому, отправляем сообщение целиком
                $firstPart = 'Не найдено';
                $secondPart = $errorMessage;
            }




            answerCallbackQuery($callbackQueryID, "Введите ошибку в формате 79787177777 текст");


            setAdminState($pdo, $chatId, 'manager', "waiting_for_supplier_error_description_{$supplierId}_{$errorId}");
            // Редактируем сообщение с ошибкой, возвращая исходное состояние
            editMessageReplyMarkup($chatId, $callbackQuery['message']['message_id'], "<b>Номер:</b> <code>$firstPart</code>\n<b>Текст:</b> <code>$secondPart</code>", $replyMarkup);

            // Логируем успешное выполнение
            //file_put_contents('log.txt', "Supplier chosen: $supplierName, error sent and message updated.\n", FILE_APPEND);

        } else {
            //file_put_contents('log.txt', "Ошибка: некорректный формат callback_data: $data\n", FILE_APPEND);
            sendMessage($chatId, "Произошла ошибка: некорректные данные для отправки ошибки поставщику.");
        }
    }
}


// Обработка нажатия на кнопку "Исправлено" поставщиком
if (isset($update['callback_query'])) {
    $callbackQuery = $update['callback_query'];
    $chatId = $callbackQuery['message']['chat']['id'];
    $data = $callbackQuery['data'];
    $userId = $callbackQuery['from']['id'];

    if (strpos($data, 'fix_supplier_error_') === 0) {
        $errorId = str_replace('fix_supplier_error_', '', $data);

        // Обновляем статус ошибки на "fixed"
        $stmt = $pdo->prepare('UPDATE errors SET status = :status WHERE id = :id');
        $stmt->execute(['status' => 'fixed', 'id' => $errorId]);

        // Получаем информацию об ошибке
        $stmt = $pdo->prepare('SELECT description,manager_id,supplier_msg FROM errors WHERE id = :id');
        $stmt->execute(['id' => $errorId]);
        $errorData = $stmt->fetch(PDO::FETCH_ASSOC);
        $chati = $callbackQuery['message']['message_id'];
        if ($errorData) {
            sendReaction($chatId, $chati, '👌');

            sendntf($errorData['manager_id'], $errorData['description'], $errorData['supplier_msg']);

            // sendMessage($errorData['manager_id'], "Ошибка помечена как исправленная: {$errorData['description']} ✅");
        } else {
            //file_put_contents('log.txt', "Ошибка: не удалось найти данные для ошибки с id $errorId\n", FILE_APPEND);
            sendMessage($chatId, "Произошла ошибка: не удалось найти данные для указанной ошибки.");
        }
    }
}

// Получаем состояние поставщика и его описание исправления





if (isset($update['message'])) {
    $message = $update['message'];
    $chatId = $message['chat']['id'];
    $text = $message['text'];

    // Получаем роль пользователя (в данном случае это менеджер)
    $role = 'manager';

    // Получаем текущее состояние для менеджера
    $stateData = getAdminState($pdo, $chatId, $role);
    $state = $stateData['state'];

    if (strpos($state, 'waiting_for_supplier_error_description_') === 0) {
        if (preg_match('/waiting_for_supplier_error_description_(\d+)_(\d+)/', $state, $matches)) {
            $supplierId = $matches[1];
            $errorId = $matches[2];

            // Обновление записи ошибки с ID поставщика
            $stmt = $pdo->prepare('UPDATE errors SET supplier_id = :supplier_id WHERE id = :id');
            $stmt->execute(['supplier_id' => $supplierId, 'id' => $errorId]);

            // Получение chat_id поставщика из таблицы suppliers
            $stmt = $pdo->prepare('SELECT chat_id FROM suppliers WHERE id = :id');
            $stmt->execute(['id' => $supplierId]);
            $supplierChatId = $stmt->fetchColumn();

            if ($supplierChatId) {
                // Отправка сообщения поставщику с описанием ошибки и кнопкой "Исправить"
                sendErrorToSupplier($supplierChatId, $text, $errorId);

                // Сообщение менеджеру о том, что ошибка отправлена поставщику
                //sendMessage($chatId, "Ошибка успешно отправлена поставщику.");

                // Очищаем состояние для менеджера
                clearAdminState($pdo, $chatId, $role);
            } else {
                file_putContents('log.txt', "Ошибка: не удалось найти chat_id для поставщика с id $supplierId\n", FILE_APPEND);
                sendMessage($chatId, "Произошла ошибка: не удалось найти chat_id поставщика.");
            }
        }
    }
}
