<?php

// Настройка обработки ошибок PHP
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/log_php.txt');
error_reporting(E_ALL);

// Подключение конфигурационного файла
$config = require 'config.php';

function answerCallbackQuery($callbackQueryID, $text)
{
    global $config;
    $token = $config['telegram']['token'];
    $params = [
        'callback_query_id' => $callbackQueryID,
        'text' => $text
    ];

    $ch = curl_init('https://api.telegram.org/bot' . $token . '/answerCallbackQuery');
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);
}

function editMessageReplyMarkup($chatId, $messageId, $newText, $replyMarkup)
{
    global $config;
    $token = $config['telegram']['token'];
    $url = "https://api.telegram.org/bot$token/editMessageText";

    $postFields = [
        'chat_id' => $chatId,
        'message_id' => $messageId,
        'text' => $newText,
        'parse_mode' => "html",
        'reply_markup' => json_encode($replyMarkup)
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_HTTPHEADER, array("Content-Type:application/json"));
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postFields));
    $output = curl_exec($ch);
    curl_close($ch);
}

// Функция для отправки сообщений через Telegram API
function sendMessage($chat_id, $text, $replyMarkup = null, $replyToMessageId = null)
{
    global $config;
    $token = $config['telegram']['token'];
    $url = "https://api.telegram.org/bot$token/sendMessage?chat_id=$chat_id&text=" . urlencode($text);

    if ($replyMarkup) {
        $url .= "&reply_markup=" . urlencode(json_encode($replyMarkup));
    }

    if ($replyToMessageId) {
        $url .= "&reply_to_message_id=$replyToMessageId";
    }

    $response = file_get_contents($url);
}

// Подключение к базе данных
function getPDOConnection($config)
{
    $dsn = "mysql:host={$config['database']['host']};dbname={$config['database']['db']};charset={$config['database']['charset']}";
    $options = [
        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES   => false,
    ];

    try {
        $pdo = new PDO($dsn, $config['database']['user'], $config['database']['pass'], $options);
        return $pdo;
    } catch (\PDOException $e) {
        error_log('Ошибка подключения к базе данных: ' . $e->getMessage());
        die('Ошибка подключения к базе данных.');
    }
}

$pdo = getPDOConnection($config);

// Функции для работы с базой данных
function getAllSuppliers($pdo)
{
    try {
        $stmt = $pdo->query('SELECT id, name FROM suppliers');
        return $stmt->fetchAll();
    } catch (\PDOException $e) {
        error_log('Ошибка получения поставщиков: ' . $e->getMessage());
        return [];
    }
}

// Функции для работы с состояниями администратора
function setAdminState($pdo, $chat_id, $role, $state, $extra_data = null)
{
    try {
        $stmt = $pdo->prepare('REPLACE INTO admin_states (chat_id, role, state, extra_data) VALUES (:chat_id, :role, :state, :extra_data)');
        $stmt->execute([
            'chat_id' => $chat_id,
            'role' => $role,
            'state' => $state,
            'extra_data' => $extra_data
        ]);
    } catch (\PDOException $e) {
        error_log('Ошибка установки состояния: ' . $e->getMessage());
    }
}

function getAdminState($pdo, $chat_id, $role)
{
    try {
        $stmt = $pdo->prepare('SELECT state, extra_data FROM admin_states WHERE chat_id = :chat_id AND role = :role');
        $stmt->execute(['chat_id' => $chat_id, 'role' => $role]);
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        return $result;
    } catch (\PDOException $e) {
        error_log('Ошибка получения состояния: ' . $e->getMessage());
        return null;
    }
}

function clearAdminState($pdo, $chat_id, $role)
{
    try {
        $stmt = $pdo->prepare('DELETE FROM admin_states WHERE chat_id = :chat_id AND role = :role');
        $stmt->execute([
            'chat_id' => $chat_id,
            'role' => $role
        ]);
    } catch (\PDOException $e) {
        error_log('Ошибка очистки состояния: ' . $e->getMessage());
    }
}

// Инициализация
$content = file_get_contents("php://input");
$update = json_decode($content, true);

$adminIds = $config['admin_ids'];

if (isset($update['message'])) {
    $message = $update['message'];
    $chatId = $message['chat']['id'];
    $text = $message['text'];

    if ($text === '/start' && in_array($chatId, $adminIds)) {
        // Отправляем кнопку для открытия админки
        $replyMarkup = [
            'inline_keyboard' => [
                [
                    [
                        'text' => '🔧 Открыть Админку',
                        'web_app' => ['url' => 'https://forzabot.pro/webapp.php']
                    ]
                ]
            ]
        ];

        sendMessage($chatId, "Добро пожаловать в панель управления!", $replyMarkup);
    }
}

// Подключаем файл clients.php
require 'clients.php';

// Логика обработки входящего сообщения
if (isset($update['message'])) {
    $message = $update['message'];
    $chatId = $message['chat']['id'];
    $text = $message['text'];

    // Проверяем, является ли чат менеджером или поставщиком
    if (!isManager($pdo, $chatId) && !isSupplier($pdo, $chatId)) {
        // Если это не менеджер и не поставщик, обрабатываем сообщение как от клиента
        handleClientMessage($pdo, $chatId, $message);
    }
}

if (isset($update['callback_query'])) {
    $callbackQuery = $update['callback_query'];
    $chatId = $callbackQuery['message']['chat']['id'];
    $messageId = $callbackQuery['message']['message_id'];
    $data = $callbackQuery['data'];
    $userId = $callbackQuery['from']['id'];
    $callbackQueryID = $callbackQuery['id'];

    // Обработка нажатия на кнопку "Не найдено"
    if (strpos($data, 'not_found_error_') === 0) {
        $errorId = str_replace('not_found_error_', '', $data);

        // Получаем информацию об ошибке
        $stmt = $pdo->prepare('SELECT client_id, client_message_id, description FROM errors WHERE id = :id');
        $stmt->execute(['id' => $errorId]);
        $errorData = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($errorData) {
            $clientId = $errorData['client_id'];
            $clientMessageId = $errorData['client_message_id'];

            // Получаем chat_id клиента
            $stmt = $pdo->prepare('SELECT chat_id FROM clients WHERE id = :client_id');
            $stmt->execute(['client_id' => $clientId]);
            $clientChatId = $stmt->fetchColumn();

            if ($clientChatId) {
                $pattern = '/^(7\d{10}|375\d{9})\s+(.+)$/';
                if (preg_match($pattern, $errorData['description'], $matches)) {
                    $phoneNumber = $matches[1];
                    $errorText = $matches[2];
                } else {
                    $phoneNumber = 'Не найден';
                    $errorText = $errorMessage;
                }
                // Отправляем сообщение клиенту с реакцией ❌
                answerCallbackQuery($callbackQueryID, "Ошибка 'Не найдено' отправлена клиенту❌");

                sendMessage($clientChatId, $errorData['description'] . " - Данный вызов не найден в нашей базе. Просьба проверить верность " . $phoneNumber . " номера.", null, $clientMessageId);
                sendReaction($clientChatId, $clientMessageId, '🤷‍♂️');
            } else {
                sendMessage($chatId, "Произошла ошибка: не удалось найти chat_id клиента.");
            }
        } else {
            sendMessage($chatId, "Произошла ошибка: не удалось найти данные для указанной ошибки.");
        }
    }

    // Обработка нажатия на кнопку "Исправлено"
    if (strpos($data, 'fix_error_') === 0) {
        $errorId = str_replace('fix_error_', '', $data);

        // Обновление статуса ошибки
        $stmt = $pdo->prepare('UPDATE errors SET status = :status WHERE id = :id');
        $stmt->execute(['status' => 'fixed', 'id' => $errorId]);

        // Получение информации об ошибке
        $stmt = $pdo->prepare('SELECT client_id, client_message_id, description,supplier_msg,manager_id FROM errors WHERE id = :id');
        $stmt->execute(['id' => $errorId]);
        $errorData = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($errorData) {
            $clientId = $errorData['client_id'];
            $clientMessageId = $errorData['client_message_id'];

            // Получение chat_id клиента
            $stmt = $pdo->prepare('SELECT chat_id FROM clients WHERE id = :client_id');
            $stmt->execute(['client_id' => $clientId]);
            $clientChatId = $stmt->fetchColumn();

            if ($clientChatId) {
                sendMessage($clientChatId, $errorData['description'] . "\n" . "Ошибка исправлена ✅", null, $clientMessageId);
                sendReaction($clientChatId, $clientMessageId, '👍');

                answerCallbackQuery($callbackQueryID, "Ошибка клиента исправлена ✅");

                sendReaction($errorData['manager_id'], $errorData['supplier_msg'], '👍');
            } else {
                sendMessage($chatId, "Произошла ошибка: не удалось найти chat_id клиента.");
            }
        } else {
            sendMessage($chatId, "Произошла ошибка: не удалось найти данные для указанной ошибки.");
        }
    }

    // Обработка нажатия на кнопку "Обрабатываю"
    elseif (strpos($data, 'process_error_') === 0) {
        $errorId = str_replace('process_error_', '', $data);

        // Получаем данные ошибки
        $stmt = $pdo->prepare('SELECT manager_id FROM errors WHERE id = :id');
        $stmt->execute(['id' => $errorId]);
        $errorData = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($errorData) {
            $msgm = $callbackQuery['message']['message_id'];
            $chatIdd = $callbackQuery['message']['chat']['id'];

            // Обновляем данные об ошибке
            $stmt = $pdo->prepare('UPDATE errors SET manager_id = :manager_id, status = :status ,supplier_msg = :supplier_msg  WHERE id = :id');
            $stmt->execute(['manager_id' => $chatIdd, 'supplier_msg' => $msgm, 'status' => 'processing', 'id' => $errorId]);

            $suppliers = getAllSuppliers($pdo);
            $keyboard = [];
            foreach ($suppliers as $supplier) {
                $keyboard[] = [
                    [
                        'text' => $supplier['name'],
                        'callback_data' => "send_error_to_supplier_{$supplier['id']}_$errorId"
                    ]
                ];
            }

            $replyMarkup = [
                'inline_keyboard' => $keyboard
            ];

            editMessageReplyMarkup($chatId, $msgm, "Выберите поставщика для отправки ошибки:", $replyMarkup);
        } else {
            sendMessage($chatId, "Ошибка: не удалось найти данные для ошибки.");
            return;
        }
    } elseif (strpos($data, 'send_error_to_supplier_') === 0) {
        if (preg_match('/send_error_to_supplier_(\d+)_(\d+)/', $data, $matches)) {
            $supplierId = $matches[1];
            $errorId = $matches[2];

            // Получаем имя поставщика
            $stmt = $pdo->prepare('SELECT name FROM suppliers WHERE id = :id');
            $stmt->execute(['id' => $supplierId]);
            $supplierName = $stmt->fetchColumn();

            // Обработка отправки ошибки поставщику (например, через API)
            if ($supplierName === 'Amerik') {
                // Специальная обработка для Amerik
                $supplierChatId = $chatId;

                function sendSms($chat_id, $text)
                {
                    // Проверка chat_id на числовое значение
                    if (!is_numeric($chat_id)) {
                        throw new InvalidArgumentException('chat_id должен быть числом.');
                    }
                    // URL для отправки запроса
                    $url = 'https://smsapi.hefservice.com/api/';
                    // Данные для отправки
                    $data = [
                        'chat_id' => $chat_id,
                        'text' => $text
                    ];
                    // Инициализация cURL
                    $ch = curl_init($url);
                    // Настройки cURL
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($ch, CURLOPT_POST, true);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
                    // Выполнение запроса
                    $response = curl_exec($ch);
                    // Проверка на ошибки
                    if (curl_errno($ch)) {
                        echo 'Ошибка cURL: ' . curl_error($ch);
                    }
                    // Закрытие cURL сессии
                    curl_close($ch);
                    return $response;
                }
                
                $stmt = $pdo->prepare('SELECT description FROM errors WHERE id = :id');
                $stmt->execute(['id' => $errorId]);
                $errorDescription = $stmt->fetchColumn();

                // Выполняем отправку сообщения поставщику
                $response = sendSms(-1001915459484, $errorDescription);
            }

            // Восстанавливаем исходное сообщение для менеджера
            $stmt = $pdo->prepare('SELECT description FROM errors WHERE id = :id');
            $stmt->execute(['id' => $errorId]);
            $errorDescription = $stmt->fetchColumn();

            $replyMarkup = [
                'inline_keyboard' => [
                    [
                        [
                            'text' => 'Обрабатываю',
                            'callback_data' => "process_error_$errorId"
                        ],
                        [
                            'text' => 'Исправлено',
                            'callback_data' => "fix_error_$errorId"
                        ]
                    ]
                ]
            ];

            $pattern = '/^(\S+)\s+(.+)$/';
            if (preg_match($pattern, $errorDescription, $matches)) {
                $firstPart = $matches[1];
                $secondPart = $matches[2];
            } else {
                $firstPart = 'Не найдено';
                $secondPart = $errorMessage;
            }

            answerCallbackQuery($callbackQueryID, "Введите ошибку в формате 79787177777 текст");

            setAdminState($pdo, $chatId, 'manager', "waiting_for_supplier_error_description_{$supplierId}_{$errorId}");
            editMessageReplyMarkup($chatId, $callbackQuery['message']['message_id'], "<b>Номер:</b> <code>$firstPart</code>\n<b>Текст:</b> <code>$secondPart</code>", $replyMarkup);

        } else {
            sendMessage($chatId, "Произошла ошибка: некорректные данные для отправки ошибки поставщику.");
        }
    }
}

// Обработка нажатия на кнопку "Исправлено" поставщиком
if (isset($update['callback_query'])) {
    $callbackQuery = $update['callback_query'];
    $chatId = $callbackQuery['message']['chat']['id'];
    $data = $callbackQuery['data'];
    $userId = $callbackQuery['from']['id'];

    if (strpos($data, 'fix_supplier_error_') === 0) {
        $errorId = str_replace('fix_supplier_error_', '', $data);

        // Обновляем статус ошибки на "fixed"
        $stmt = $pdo->prepare('UPDATE errors SET status = :status WHERE id = :id');
        $stmt->execute(['status' => 'fixed', 'id' => $errorId]);

        // Получаем информацию об ошибке
        $stmt = $pdo->prepare('SELECT description,manager_id,supplier_msg FROM errors WHERE id = :id');
        $stmt->execute(['id' => $errorId]);
        $errorData = $stmt->fetch(PDO::FETCH_ASSOC);
        $chati = $callbackQuery['message']['message_id'];
        if ($errorData) {
            sendReaction($chatId, $chati, '👌');
            sendntf($errorData['manager_id'], $errorData['description'], $errorData['supplier_msg']);
        } else {
            sendMessage($chatId, "Произошла ошибка: не удалось найти данные для указанной ошибки.");
        }
    }
}

if (isset($update['message'])) {
    $message = $update['message'];
    $chatId = $message['chat']['id'];
    $text = $message['text'];

    // Получаем роль пользователя (в данном случае это менеджер)
    $role = 'manager';

    // Получаем текущее состояние для менеджера
    $stateData = getAdminState($pdo, $chatId, $role);
    $state = $stateData['state'];

    if (strpos($state, 'waiting_for_supplier_error_description_') === 0) {
        if (preg_match('/waiting_for_supplier_error_description_(\d+)_(\d+)/', $state, $matches)) {
            $supplierId = $matches[1];
            $errorId = $matches[2];

            // Обновление записи ошибки с ID поставщика
            $stmt = $pdo->prepare('UPDATE errors SET supplier_id = :supplier_id WHERE id = :id');
            $stmt->execute(['supplier_id' => $supplierId, 'id' => $errorId]);

            // Получение chat_id поставщика из таблицы suppliers
            $stmt = $pdo->prepare('SELECT chat_id FROM suppliers WHERE id = :id');
            $stmt->execute(['id' => $supplierId]);
            $supplierChatId = $stmt->fetchColumn();

            if ($supplierChatId) {
                // Отправка сообщения поставщику с описанием ошибки и кнопкой "Исправить"
                sendErrorToSupplier($supplierChatId, $text, $errorId);

                // Очищаем состояние для менеджера
                clearAdminState($pdo, $chatId, $role);
            } else {
                sendMessage($chatId, "Произошла ошибка: не удалось найти chat_id поставщика.");
            }
        }
    }
}