<?php
// Запускаем сессию в самом начале
session_start();

// --- ЛОГИКА АВТОРИЗАЦИИ ---

$valid_username = 'admin';
$valid_password = 'Aze43Faaaa'; // В реальном проекте пароль нужно хешировать!

// Обработка выхода из системы
if (isset($_GET['logout'])) {
    session_destroy();
    header('Location: admin.php');
    exit;
}

$error_message = '';
// Обработка отправленной формы входа
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';

    if ($username === $valid_username && $password === $valid_password) {
        // Если данные верны, сохраняем статус в сессию и перезагружаем страницу
        $_SESSION['loggedin'] = true;
        $_SESSION['username'] = $username;
        header('Location: admin.php');
        exit;
    } else {
        $error_message = 'Неверный логин или пароль.';
    }
}

// Проверяем, вошел ли пользователь в систему
$is_loggedin = isset($_SESSION['loggedin']) && $_SESSION['loggedin'] === true;

?>
<!DOCTYPE html>
<html lang="ru" class="h-full <?php echo $is_loggedin ? 'bg-gray-100' : 'bg-gray-200'; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $is_loggedin ? 'Админ-панель' : 'Вход'; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
</head>
<body class="h-full">

<?php if ($is_loggedin): ?>

    <div>
        <?php require 'admin_sidebar.php'; // <-- ПОДКЛЮЧАЕМ САЙДБАР ?>

        <div class="flex flex-col flex-1 md:pl-64">
            <div class="sticky top-0 z-10 md:hidden h-16 bg-white shadow-sm flex items-center px-4">
                <button id="hamburger-btn" type="button" class="text-gray-500 hover:text-gray-600">
                    <i class="fas fa-bars text-xl"></i>
                </button>
                <div class="flex-1 text-center text-lg font-medium">Панель управления</div>
            </div>

            <main class="flex-1 p-6">
                <div class="max-w-7xl mx-auto">
                    <h1 class="text-3xl font-bold text-gray-900">Добро пожаловать в админ панель</h1>
                    <p class="mt-2 text-gray-600">Используйте меню слева для навигации по разделам.</p>
                </div>
            </main>
        </div>
    </div>
    
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const hamburgerBtn = document.getElementById('hamburger-btn');
            const mobileSidebar = document.getElementById('mobile-sidebar');
            const backdrop = document.getElementById('mobile-sidebar-backdrop');
            if (hamburgerBtn) {
                function toggleSidebar() {
                    mobileSidebar.classList.toggle('-translate-x-full');
                    backdrop.classList.toggle('hidden');
                }
                hamburgerBtn.addEventListener('click', toggleSidebar);
                backdrop.addEventListener('click', toggleSidebar);
            }
        });
    </script>

<?php else: ?>

    <div class="min-h-full flex items-center justify-center py-12 px-4 sm:px-6 lg:px-8">
        <div class="max-w-md w-full space-y-8 bg-white p-10 rounded-xl shadow-lg">
            <div>
                <h2 class="mt-6 text-center text-3xl font-extrabold text-gray-900">
                    Вход в панель
                </h2>
            </div>
            <form class="mt-8 space-y-6" action="admin.php" method="POST">
                <input type="hidden" name="remember" value="true">
                <div class="rounded-md shadow-sm -space-y-px">
                    <div>
                        <label for="username" class="sr-only">Логин</label>
                        <input id="username" name="username" type="text" required class="appearance-none rounded-none relative block w-full px-3 py-2 border border-gray-300 placeholder-gray-500 text-gray-900 rounded-t-md focus:outline-none focus:ring-sky-500 focus:border-sky-500 focus:z-10 sm:text-sm" placeholder="Логин">
                    </div>
                    <div>
                        <label for="password" class="sr-only">Пароль</label>
                        <input id="password" name="password" type="password" required class="appearance-none rounded-none relative block w-full px-3 py-2 border border-gray-300 placeholder-gray-500 text-gray-900 rounded-b-md focus:outline-none focus:ring-sky-500 focus:border-sky-500 focus:z-10 sm:text-sm" placeholder="Пароль">
                    </div>
                </div>

                <?php if ($error_message): ?>
                    <p class="text-sm text-red-600"><?php echo $error_message; ?></p>
                <?php endif; ?>

                <div>
                    <button type="submit" class="group relative w-full flex justify-center py-2 px-4 border border-transparent text-sm font-medium rounded-md text-white bg-sky-600 hover:bg-sky-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-sky-500">
                        Войти
                    </button>
                </div>
            </form>
        </div>
    </div>

<?php endif; ?>

</body>
</html>