<?php $currentPage = basename($_SERVER['PHP_SELF']); // Определяем текущую страницу ?>

<div id="mobile-sidebar-backdrop" class="fixed inset-0 bg-gray-900/80 z-30 hidden md:hidden"></div>
<div id="mobile-sidebar" class="fixed inset-y-0 left-0 z-40 w-64 bg-gray-900 text-white p-4 transform -translate-x-full transition-transform duration-300 ease-in-out md:hidden">
    <div class="flex flex-col h-full">
        <a href="admin.php" class="flex items-center gap-3 px-3 mb-8">
            <i class="fas fa-robot text-2xl text-sky-400"></i>
            <span class="text-xl font-semibold">Админ-панель</span>
        </a>
        <nav class="flex-1 space-y-2">
            <a href="admin_base.php" class="flex items-center gap-3 px-3 py-2 rounded-md text-sm font-medium hover:bg-gray-700 hover:text-white <?php echo $currentPage == 'admin_base.php' ? 'bg-sky-600' : 'text-gray-300'; ?>">
                <i class="fas fa-database fa-fw"></i>
                <span>База данных</span>
            </a>
            <a href="admin_logs.php" class="flex items-center gap-3 px-3 py-2 rounded-md text-sm font-medium hover:bg-gray-700 hover:text-white <?php echo $currentPage == 'admin_logs.php' ? 'bg-sky-600' : 'text-gray-300'; ?>">
                <i class="fas fa-file-alt fa-fw"></i>
                <span>Логи</span>
            </a>
            <a href="admin_settings.php" class="flex items-center gap-3 px-3 py-2 rounded-md text-sm font-medium hover:bg-gray-700 hover:text-white <?php echo $currentPage == 'admin_settings.php' ? 'bg-sky-600' : 'text-gray-300'; ?>">
                <i class="fas fa-cog fa-fw"></i>
                <span>Настройки</span>
            </a>
        </nav>
        <div class="mt-auto">
            <a href="admin.php?logout=true" class="flex items-center w-full gap-3 px-3 py-2 rounded-md text-sm font-medium text-gray-300 hover:bg-red-600 hover:text-white">
                <i class="fas fa-sign-out-alt fa-fw"></i>
                <span>Выйти</span>
            </a>
        </div>
    </div>
</div>

<div class="hidden md:flex md:w-64 md:flex-col md:fixed md:inset-y-0">
    <div class="flex flex-col flex-grow bg-gray-900 text-white p-4">
        <a href="admin.php" class="flex items-center gap-3 px-3 mb-8 flex-shrink-0">
            <i class="fas fa-robot text-2xl text-sky-400"></i>
            <span class="text-xl font-semibold">Админ-панель</span>
        </a>
        <nav class="flex-1 space-y-2">
            <a href="admin_base.php" class="flex items-center gap-3 px-3 py-2 rounded-md text-sm font-medium hover:bg-gray-700 hover:text-white <?php echo $currentPage == 'admin_base.php' ? 'bg-sky-600' : 'text-gray-300'; ?>">
                <i class="fas fa-database fa-fw"></i>
                <span>База данных</span>
            </a>
            <a href="admin_logs.php" class="flex items-center gap-3 px-3 py-2 rounded-md text-sm font-medium hover:bg-gray-700 hover:text-white <?php echo $currentPage == 'admin_logs.php' ? 'bg-sky-600' : 'text-gray-300'; ?>">
                <i class="fas fa-file-alt fa-fw"></i>
                <span>Логи</span>
            </a>
            <a href="admin_settings.php" class="flex items-center gap-3 px-3 py-2 rounded-md text-sm font-medium hover:bg-gray-700 hover:text-white <?php echo $currentPage == 'admin_settings.php' ? 'bg-sky-600' : 'text-gray-300'; ?>">
                <i class="fas fa-cog fa-fw"></i>
                <span>Настройки</span>
            </a>
        </nav>
        <div class="mt-auto flex-shrink-0">
            <a href="admin.php?logout=true" class="flex items-center w-full gap-3 px-3 py-2 rounded-md text-sm font-medium text-gray-300 hover:bg-red-600 hover:text-white">
                <i class="fas fa-sign-out-alt fa-fw"></i>
                <span>Выйти</span>
            </a>
        </div>
    </div>
</div>