<?php
// --- ПРОВЕРКА АВТОРИЗАЦИИ ---
session_start();

if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header('Location: admin.php');
    exit;
}

// --- ЧТЕНИЕ И ОБРАБОТКА ЛОГ-ФАЙЛА ---
$log_file_path = 'log.txt';
$log_content = '';

if (file_exists($log_file_path)) {
    $raw_content = htmlspecialchars(file_get_contents($log_file_path));
    $lines = explode("\n", $raw_content);
    $processed_lines = [];
    foreach ($lines as $line) {
        // Подсветка строк
        if (stripos($line, 'Error') !== false || stripos($line, 'Failed') !== false || stripos($line, 'Bad Request') !== false) {
            $processed_lines[] = '<span class="text-red-400">' . $line . '</span>';
        } elseif (stripos($line, 'added') !== false || stripos($line, 'sent') !== false || stripos($line, 'Fetched') !== false) {
            $processed_lines[] = '<span class="text-green-400">' . $line . '</span>';
        } elseif (trim($line) === '(' || trim($line) === ')') {
             $processed_lines[] = '<span class="text-yellow-400">' . $line . '</span>';
        }
        else {
            $processed_lines[] = '<span class="text-gray-300">' . $line . '</span>';
        }
    }
    $log_content = implode("\n", $processed_lines);
} else {
    $log_content = '<span class="text-yellow-400">Файл log.txt не найден.</span>';
}

?>
<!DOCTYPE html>
<html lang="ru" class="h-full bg-gray-100">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Логи - Админ-панель</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
</head>
<body class="h-full">

    <div>
        <?php require 'admin_sidebar.php'; // Подключаем сайдбар ?>

        <div class="flex flex-col flex-1 md:pl-64">
            <div class="sticky top-0 z-10 md:hidden h-16 bg-white shadow-sm flex items-center px-4">
                <button id="hamburger-btn" type="button" class="text-gray-500 hover:text-gray-600">
                    <i class="fas fa-bars text-xl"></i>
                </button>
                <div class="flex-1 text-center text-lg font-medium">Логи</div>
            </div>

            <main class="flex-1 p-6">
                <div class="max-w-7xl mx-auto">
                    <h1 class="text-3xl font-bold text-gray-900">Системные логи</h1>

                    <div class="mt-6 bg-gray-900 rounded-lg shadow-lg overflow-hidden">
                        <div class="p-4 bg-gray-800 text-sm text-gray-400 font-semibold">
                            /var/www/html/log.txt
                        </div>
                        <div id="terminal-content" class="p-4 font-mono text-sm h-96 overflow-y-auto">
                            <div id="loading-message">
                                <p class="text-yellow-400 animate-pulse">Ожидайте.....</p>
                            </div>
                            
                            <pre id="log-data" class="hidden whitespace-pre-wrap"><?php echo $log_content; ?></pre>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>
    
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            // Скрипт для мобильного меню (без изменений)
            const hamburgerBtn = document.getElementById('hamburger-btn');
            const mobileSidebar = document.getElementById('mobile-sidebar');
            const backdrop = document.getElementById('mobile-sidebar-backdrop');
            if (hamburgerBtn) {
                function toggleSidebar() {
                    mobileSidebar.classList.toggle('-translate-x-full');
                    backdrop.classList.toggle('hidden');
                }
                hamburgerBtn.addEventListener('click', toggleSidebar);
                backdrop.addEventListener('click', toggleSidebar);
            }

            // Скрипт для "загрузки" логов
            const loadingMessage = document.getElementById('loading-message');
            const logData = document.getElementById('log-data');

            setTimeout(() => {
                loadingMessage.classList.add('hidden');
                logData.classList.remove('hidden');
            }, 1000); // задержка в 1 секунду
        });
    </script>
</body>
</html>