<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <title>Админ панель</title>
    <script src="https://telegram.org/js/telegram-web-app.js"></script>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
</head>
<body class="bg-gray-50 min-h-screen">
    <!-- Проверка доступа -->
    <div id="loader" class="flex items-center justify-center min-h-screen">
        <div class="text-center">
            <div class="animate-spin rounded-full h-12 w-12 border-b-2 border-blue-600 mx-auto mb-4"></div>
            <p class="text-gray-600">Проверка доступа...</p>
        </div>
    </div>

    <!-- Доступ запрещен -->
    <div id="denied" class="hidden flex items-center justify-center min-h-screen">
        <div class="text-center bg-white p-8 rounded-2xl shadow-lg max-w-sm mx-4">
            <i class="fas fa-ban text-5xl text-red-500 mb-4"></i>
            <h2 class="text-xl font-bold text-gray-900 mb-2">Доступ запрещен</h2>
            <p class="text-gray-600">У вас нет прав администратора</p>
        </div>
    </div>

    <!-- Основное приложение -->
    <div id="app" class="hidden">
        <!-- Шапка -->
        <div class="bg-white shadow-sm border-b px-4 py-3">
            <div class="max-w-md mx-auto">
                <div class="flex items-center justify-between mb-3">
                    <h1 id="title" class="text-lg font-bold">Админ панель</h1>
                    <div class="w-8 h-8 bg-blue-600 rounded-full flex items-center justify-center">
                        <i class="fas fa-user-shield text-white text-sm"></i>
                    </div>
                </div>
                <div class="flex justify-center">
                    <button id="backBtn" class="hidden bg-blue-500 hover:bg-blue-600 text-white px-6 py-2.5 rounded-full text-sm font-medium transition-all duration-200 shadow-md hover:shadow-lg active:scale-95" onclick="goBack()">
                        <i class="fas fa-arrow-left mr-2"></i>
                        Назад
                    </button>
                </div>
            </div>
        </div>

        <div class="max-w-md mx-auto p-4">
            <!-- Главное меню -->
            <div id="mainMenu">
                <div class="grid grid-cols-2 gap-3 mb-4">
                    <div class="bg-white p-4 rounded-xl shadow-sm cursor-pointer hover:shadow-md transition-shadow" onclick="showAddManager()">
                        <i class="fas fa-user-plus text-2xl text-blue-600 mb-2"></i>
                        <p class="font-medium text-sm">Добавить менеджера</p>
                    </div>
                    <div class="bg-white p-4 rounded-xl shadow-sm cursor-pointer hover:shadow-md transition-shadow" onclick="showAddSupplier()">
                        <i class="fas fa-truck text-2xl text-green-600 mb-2"></i>
                        <p class="font-medium text-sm">Добавить поставщика</p>
                    </div>
                </div>
                <div class="space-y-2">
                    <div class="bg-white p-4 rounded-xl shadow-sm cursor-pointer hover:shadow-md transition-shadow flex items-center justify-between" onclick="showManagers()">
                        <div class="flex items-center">
                            <i class="fas fa-users text-purple-600 mr-3"></i>
                            <span class="font-medium">Менеджеры</span>
                        </div>
                        <i class="fas fa-chevron-right text-gray-400"></i>
                    </div>
                    <div class="bg-white p-4 rounded-xl shadow-sm cursor-pointer hover:shadow-md transition-shadow flex items-center justify-between" onclick="showSuppliers()">
                        <div class="flex items-center">
                            <i class="fas fa-boxes text-orange-600 mr-3"></i>
                            <span class="font-medium">Поставщики</span>
                        </div>
                        <i class="fas fa-chevron-right text-gray-400"></i>
                    </div>
                </div>
            </div>

            <!-- Добавить менеджера -->
            <div id="addManagerPage" class="hidden">
                <div class="bg-white p-6 rounded-xl shadow-sm">
                    <div id="managerMsg" class="mb-4"></div>
                    <div class="space-y-4">
                        <input type="number" id="managerChatId" placeholder="Chat ID менеджера" class="w-full p-3 border rounded-lg focus:border-blue-500 outline-none">
                        <input type="text" id="managerName" placeholder="Имя менеджера" class="w-full p-3 border rounded-lg focus:border-blue-500 outline-none">
                        <button onclick="addManager()" class="w-full bg-blue-600 text-white p-3 rounded-lg font-medium hover:bg-blue-700">
                            Добавить менеджера
                        </button>
                    </div>
                </div>
            </div>

            <!-- Добавить поставщика -->
            <div id="addSupplierPage" class="hidden">
                <div class="bg-white p-6 rounded-xl shadow-sm">
                    <div id="supplierMsg" class="mb-4"></div>
                    <div class="space-y-4">
                        <input type="number" id="supplierChatId" placeholder="Chat ID поставщика" class="w-full p-3 border rounded-lg focus:border-green-500 outline-none">
                        <input type="text" id="supplierName" placeholder="Название поставщика" class="w-full p-3 border rounded-lg focus:border-green-500 outline-none">
                        <button onclick="addSupplier()" class="w-full bg-green-600 text-white p-3 rounded-lg font-medium hover:bg-green-700">
                            Добавить поставщика
                        </button>
                    </div>
                </div>
            </div>

            <!-- Список менеджеров -->
            <div id="managersPage" class="hidden">
                <div class="bg-white rounded-xl shadow-sm">
                    <div class="p-4 border-b">
                        <h3 class="font-medium">Менеджеры</h3>
                    </div>
                    <div id="managersList" class="p-4">Загрузка...</div>
                </div>
            </div>

            <!-- Список поставщиков -->
            <div id="suppliersPage" class="hidden">
                <div class="bg-white rounded-xl shadow-sm">
                    <div class="p-4 border-b">
                        <h3 class="font-medium">Поставщики</h3>
                    </div>
                    <div id="suppliersList" class="p-4">Загрузка...</div>
                </div>
            </div>
        </div>
    </div>

    <script>
        const tg = window.Telegram.WebApp;
        tg.ready();
        tg.expand();

        const ADMIN_ID = 7450916080;

        // Проверка доступа
        if (tg.initDataUnsafe?.user?.id === ADMIN_ID) {
            document.getElementById('loader').classList.add('hidden');
            document.getElementById('app').classList.remove('hidden');
        } else {
            document.getElementById('loader').classList.add('hidden');
            document.getElementById('denied').classList.remove('hidden');
        }

        // Навигация
        function showPage(pageId, title) {
            document.querySelectorAll('[id$="Page"], #mainMenu').forEach(el => el.classList.add('hidden'));
            document.getElementById(pageId).classList.remove('hidden');
            document.getElementById('title').textContent = title;
            document.getElementById('backBtn').classList.toggle('hidden', pageId === 'mainMenu');
        }

        function goBack() { showPage('mainMenu', 'Админ панель'); }
        function showAddManager() { showPage('addManagerPage', 'Добавить менеджера'); clearInputs(['managerChatId', 'managerName']); }
        function showAddSupplier() { showPage('addSupplierPage', 'Добавить поставщика'); clearInputs(['supplierChatId', 'supplierName']); }
        function showManagers() { showPage('managersPage', 'Менеджеры'); loadManagers(); }
        function showSuppliers() { showPage('suppliersPage', 'Поставщики'); loadSuppliers(); }

        // Утилиты
        function clearInputs(ids) { ids.forEach(id => document.getElementById(id).value = ''); }
        
        function showMsg(id, text, type = 'success') {
            const className = type === 'success' ? 'bg-green-100 text-green-800 border-green-200' : 'bg-red-100 text-red-800 border-red-200';
            document.getElementById(id).innerHTML = `<div class="${className} border p-3 rounded-lg">${text}</div>`;
            setTimeout(() => document.getElementById(id).innerHTML = '', 3000);
        }

        async function api(action, data = {}) {
            try {
                const res = await fetch('admin_api.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ action, ...data })
                });
                return await res.json();
            } catch (e) {
                return { success: false, message: 'Ошибка сети' };
            }
        }

        // API функции
        async function addManager() {
            const chatId = document.getElementById('managerChatId').value.trim();
            const name = document.getElementById('managerName').value.trim();
            
            if (!chatId || !name) {
                showMsg('managerMsg', 'Заполните все поля', 'error');
                return;
            }
            
            const result = await api('addManager', { chat_id: chatId, name });
            showMsg('managerMsg', result.message, result.success ? 'success' : 'error');
            
            if (result.success) clearInputs(['managerChatId', 'managerName']);
        }

        async function addSupplier() {
            const chatId = document.getElementById('supplierChatId').value.trim();
            const name = document.getElementById('supplierName').value.trim();
            
            if (!chatId || !name) {
                showMsg('supplierMsg', 'Заполните все поля', 'error');
                return;
            }
            
            const result = await api('addSupplier', { chat_id: chatId, name });
            showMsg('supplierMsg', result.message, result.success ? 'success' : 'error');
            
            if (result.success) clearInputs(['supplierChatId', 'supplierName']);
        }

        async function loadManagers() {
            const container = document.getElementById('managersList');
            container.innerHTML = 'Загрузка...';
            
            const result = await api('getManagers');
            
            if (result.success && result.data.length > 0) {
                container.innerHTML = result.data.map(m => `
                    <div class="flex items-center justify-between py-2 border-b last:border-b-0">
                        <div>
                            <div class="font-medium">${m.name}</div>
                            <div class="text-sm text-gray-500">ID: ${m.chat_id}</div>
                        </div>
                        <button onclick="deleteManager(${m.id}, '${m.name}')" class="bg-red-500 text-white px-3 py-1 rounded text-sm hover:bg-red-600">
                            Удалить
                        </button>
                    </div>
                `).join('');
            } else {
                container.innerHTML = '<div class="text-gray-500 text-center py-4">Менеджеры не найдены</div>';
            }
        }

        async function loadSuppliers() {
            const container = document.getElementById('suppliersList');
            container.innerHTML = 'Загрузка...';
            
            const result = await api('getSuppliers');
            
            if (result.success && result.data.length > 0) {
                container.innerHTML = result.data.map(s => `
                    <div class="flex items-center justify-between py-2 border-b last:border-b-0">
                        <div>
                            <div class="font-medium">${s.name}</div>
                            <div class="text-sm text-gray-500">ID: ${s.chat_id}</div>
                        </div>
                        <button onclick="deleteSupplier(${s.id}, '${s.name}')" class="bg-red-500 text-white px-3 py-1 rounded text-sm hover:bg-red-600">
                            Удалить
                        </button>
                    </div>
                `).join('');
            } else {
                container.innerHTML = '<div class="text-gray-500 text-center py-4">Поставщики не найдены</div>';
            }
        }

        async function deleteManager(id, name) {
            if (!confirm(`Удалить менеджера "${name}"?`)) return;
            const result = await api('deleteManager', { id });
            if (result.success) loadManagers();
            tg.showAlert(result.message);
        }

        async function deleteSupplier(id, name) {
            if (!confirm(`Удалить поставщика "${name}"?`)) return;
            const result = await api('deleteSupplier', { id });
            if (result.success) loadSuppliers();
            tg.showAlert(result.message);
        }

        // Telegram integration
        tg.onEvent('backButtonClicked', goBack);
    </script>
</body>
</html>